#include "ScnScreenshots.h"
#include "ScnGames.h"

HRESULT CScnScreenshots::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
    GetChildById( L"Screenshot", &m_Screenshot );
    GetChildById( L"Right", &m_Right );
    GetChildById( L"Left", &m_Left );
    GetChildById( L"AButton", &m_abutton );

	if (CurentGame->i_SSCount > 0)
	{		
		wstring ss1 = datapath_x + L"artwork/" + CurentGame->imagefolder + L"/ss-1.jpg";
		//DebugMsg("Using ss1 %s",ss1.c_str());
		m_Screenshot.SetImagePath(ss1.c_str());
	} else {
		m_Screenshot.SetImagePath(L"file://game:/media/noss.png");
	}

	CurrentShot = 1;

	return S_OK;
}

HRESULT CScnScreenshots::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{	
	if (hObjPressed == m_Left || hObjPressed == m_Right)
	{
		if (hObjPressed == m_Left)
			CurrentShot--;
		if (hObjPressed == m_Right)
			CurrentShot++;

		if (CurrentShot < 1)
			CurrentShot = CurentGame->i_SSCount;

		if (CurrentShot > CurentGame->i_SSCount)
			CurrentShot = 1;

		wstring ss1 = datapath_x + L"artwork/" + CurentGame->imagefolder + sprintfa(L"/ss-%d.jpg",CurrentShot);
		m_Screenshot.SetImagePath(ss1.c_str());
		bHandled = TRUE;

		return S_OK;
	}
    if ( hObjPressed == m_abutton )
    {
		cl.LaunchGame(CurentGame);
	}

    bHandled = FALSE;
    return S_OK;
}
